<?php

namespace Flow\FlowPayment\Helper;

class Helper extends \Magento\Framework\App\Helper\AbstractHelper
{
    public function isPaidInFlow($status)
    {
        return $status == 2;
    }

    public function isPendingInFlow($status)
    {
        return $status == 1;
    }

    public function isRejectedInFlow($status)
    {
        return $status == 3;
    }

    public function userCanceledOrder($flowData)
    {
        return $this->isPendingInFlow($flowData["status"])
                && empty($flowData['pending_info']['media'])
                && empty($flowData['payment']['media']);
    }

    public function userGeneratedCoupon($flowData)
    {
        return empty($flowData['payment']['media']) && !empty($flowData['pending_info']['media']);
    }

    public function checkDate($date, $format)
    {
        $date = \DateTime::createFromFormat($format, $date);
        return $date && $date->format($format) == $date;
    }

    public function formatPrice($price, $maxNumberOfDigits = 19)
    {
        if (strlen($price) > $maxNumberOfDigits) {
            return null;
        }
        
        return (float) number_format($price, 2, ".", "");
    }

    public function getOrderAmount($amount, $currency)
    {
        if ($currency == "CLP") { 
            $orderAmount = (float) round($amount);
        } else {
            $orderAmount = (float) $amount;
        }

        return $orderAmount;
    }
}

